<?php

  use Illuminate\Database\Migrations\Migration;
  use Illuminate\Database\Schema\Blueprint;
  use Illuminate\Support\Facades\Schema;

  class CreateExamQuestionsTable extends Migration
  {
      public function up()
      {
          Schema::create('exam_questions', function (Blueprint $table) {
              $table->id('Question_id');
              $table->unsignedBigInteger('Course_id')->notNullable();
              $table->unsignedBigInteger('Content_id')->notNullable();
              $table->text('Question_text')->notNullable();
              $table->json('Options')->notNullable()->comment('JSON array of options, e.g., [{"text":"Option 1","is_correct":true},...]');
              $table->timestamp('Created_at')->useCurrent();
              $table->timestamp('Updated_at')->useCurrent()->useCurrentOnUpdate();

              $table->foreign('Course_id')
                    ->references('course_id')
                    ->on('courses')
                    ->onDelete('cascade')
                    ->name('exam_questions_course_id_foreign');
              $table->foreign('Content_id')
                    ->references('Content_id')
                    ->on('course_content')
                    ->onDelete('cascade')
                    ->name('exam_questions_content_id_foreign');
          });
      }

      public function down()
      {
          Schema::dropIfExists('exam_questions');
      }
  }
